document.addEventListener('DOMContentLoaded', function () {
  // ================= SLIDER =================
  const slider = document.querySelector('.slider');
  if (slider) {
    const slides = Array.from(slider.querySelectorAll('.slide'));
    let current = 0;
    if (slides.length) slides[current].classList.add('active');

    const prevBtn = slider.querySelector('.prev');
    const nextBtn = slider.querySelector('.next');

    function go(toIndex, direction) {
      const oldSlide = slides[current];
      const newIndex = (toIndex + slides.length) % slides.length;
      const newSlide = slides[newIndex];

      newSlide.style.transition = "none";
      newSlide.style.transform = (direction === 'next') ? "translateX(100%)" : "translateX(-100%)";
      newSlide.offsetHeight; // force reflow

      newSlide.style.transition = "transform 0.6s ease";
      oldSlide.style.transition = "transform 0.6s ease";
      oldSlide.style.transform = (direction === 'next') ? "translateX(-100%)" : "translateX(100%)";
      newSlide.style.transform = "translateX(0)";

      newSlide.classList.add('active');
      oldSlide.classList.remove('active');
      current = newIndex;
    }

    if (prevBtn && nextBtn) {
      nextBtn.addEventListener('click', () => go(current + 1, 'next'));
      prevBtn.addEventListener('click', () => go(current - 1, 'prev'));
    }
  }

  // ================= LOAD MORE =================
  const loadBtn = document.getElementById('loadToggle');
  const loader = document.querySelector('.loader');
  const extraItems = document.querySelectorAll('.extra-items');

  if (loadBtn && loader && extraItems.length) {
    loadBtn.addEventListener('click', () => {
      loader.style.display = 'grid';
      loadBtn.style.display = 'none';

      setTimeout(() => {
        loader.style.display = 'none';

        let anyHidden = false;
        extraItems.forEach(item => {
          if (item.style.display === 'none' || item.style.display === '') {
            item.style.display = 'block';
            anyHidden = true;
          } else {
            item.style.display = 'none';
          }
        });

        loadBtn.textContent = anyHidden ? 'Load Less' : 'Load More';
        loadBtn.style.display = 'block';
      }, 500);
    });
  }

  // ================= SCROLL TO TOP =================
  const gotoBtn = document.querySelector('.gotoBtn');
  if (gotoBtn) {
    window.addEventListener("scroll", () => {
      if (window.scrollY > 300) {
        gotoBtn.classList.add("show");
      } else {
        gotoBtn.classList.remove("show");
      }
    });

    gotoBtn.addEventListener("click", () => {
      window.scrollTo({ top: 0, behavior: "smooth" });
    });
  }

  // ================= DARK MODE =================
  const toggleBtn = document.querySelector('.theme-toggle');
  if (toggleBtn) {
    const body = document.body;
    const storedMode = localStorage.getItem('mode');
    if (storedMode === 'dark') body.classList.add('dark');

    toggleBtn.addEventListener('click', () => {
      body.classList.toggle('dark');
      localStorage.setItem('mode', body.classList.contains('dark') ? 'dark' : 'light');
    });
  }

  // ================= SEARCH TOGGLE =================
  const iconWrapper = document.querySelector('.iconWrapper');
  const searchBox = document.querySelector('.searchBox');
  if (iconWrapper && searchBox) {
    let isOpen = false;
    iconWrapper.addEventListener('click', () => {
      isOpen = !isOpen;
      if (isOpen) {
        iconWrapper.innerHTML = "×";
        searchBox.style.display = "flex";
      } else {
        iconWrapper.innerHTML = '<img src="images/search.png" alt="search" style="width:18px;height:18px;">';
        searchBox.style.display = "none";
      }
    });
  }

  // ================= HAMBURGER MENU =================
  const hamburger = document.querySelector('.hamburger');
  const sidemenu = document.querySelector('.sidemenu');
  const overlay = document.querySelector('.sidemenuOverlay');
  if (hamburger && sidemenu && overlay) {
    const HAMBURGER_SRC = 'images/hamburger.png';
    const CLOSE_SRC = 'images/close.png';
    let open = false;

    hamburger.addEventListener('click', () => {
      open = !open;
      sidemenu.classList.toggle('active', open);
      overlay.classList.toggle('active', open);
      hamburger.src = open ? CLOSE_SRC : HAMBURGER_SRC;
    });

    overlay.addEventListener('click', () => {
      open = false;
      sidemenu.classList.remove('active');
      overlay.classList.remove('active');
      hamburger.src = HAMBURGER_SRC;
    });
  }
});

// ================= SCROLL LINE =================
const scrollLine = document.querySelector('.scroll-line');
if (scrollLine) {
  window.addEventListener('scroll', () => {
    const scrollTop = window.scrollY;
    const scrollHeight = document.documentElement.scrollHeight - window.innerHeight;
    const progress = (scrollTop / scrollHeight) * 100;
    scrollLine.style.width = progress + "%";
  });
}

// ================= DON'T MISS =================
const dontMiss = document.getElementById("dontMiss");
const aboutus = document.getElementById("aboutus");
const closeBtn = document.querySelector(".dm-close");

if (dontMiss && aboutus && closeBtn) {
  let shown = false;

  window.addEventListener("scroll", () => {
    if (!shown) {
      const rect = aboutus.getBoundingClientRect();
      const inView = rect.top < window.innerHeight && rect.bottom > 0;

      if (inView) {
        dontMiss.style.display = "block";
        shown = true;

        // trigger fade-up on items with stagger
        const items = dontMiss.querySelectorAll(".dm-item");
        items.forEach((item, i) => {
          item.style.animationDelay = `${i * 0.2}s`;
        });
      }
    }
  });

  closeBtn.addEventListener("click", () => {
    dontMiss.style.display = "none";
  });
}


// sticky
document.addEventListener('DOMContentLoaded', () => {
  const header = document.querySelector('.headerthree');
  if (!header) return;

  const stickyOffset = header.offsetTop;

  window.addEventListener('scroll', () => {
    if (window.scrollY > stickyOffset) {
      header.classList.add('sticky');
    } else {
      header.classList.remove('sticky');
    }
  });
});



// subscribe


    const showPopup = document.getElementById("showPopup");
    const hidePopup = document.getElementById("hidePopup");
    const popupWrapper = document.getElementById("popupWrapper");

    // Open popup
    showPopup.addEventListener("click", () => {
      popupWrapper.style.display = "flex";
    });

    // Close popup
    hidePopup.addEventListener("click", () => {
      popupWrapper.style.display = "none";
    });

    // Close when clicking outside
    window.addEventListener("click", (e) => {
      if (e.target === popupWrapper) {
        popupWrapper.style.display = "none";
      }
    });
 